/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.camera.viewfinder;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.client.animation.Animation;
import io.github.mortuusars.exposure.client.animation.EasingFunction;
import io.github.mortuusars.exposure.client.camera.viewfinder.Viewfinder;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.item.camera.CameraSettings;
import net.minecraft.class_3532;
import net.minecraft.class_5498;

public class ViewfinderSelfie {
    protected final Camera camera;
    protected final Viewfinder viewfinder;
    protected double rawXRot;
    protected double rawYRot;
    protected double xRot;
    protected double yRot;
    protected double prevXRot;
    protected double prevYRot;
    protected Animation xRotAnimation = new Animation(200, EasingFunction.EASE_OUT_EXPO);
    protected Animation yRotAnimation = new Animation(200, EasingFunction.EASE_OUT_EXPO);

    public ViewfinderSelfie(Camera camera, Viewfinder viewfinder) {
        this.camera = camera;
        this.viewfinder = viewfinder;
    }

    public void tick() {
        this.updateSelfieMode();
    }

    public float getMaxCameraDistance() {
        return ((Double)Config.Server.SELFIE_CAMERA_DISTANCE.get()).floatValue();
    }

    public double getCameraXRot() {
        return class_3532.method_16436((double)this.xRotAnimation.getValue(), (double)this.prevXRot, (double)this.xRot);
    }

    public double getCameraYRot() {
        return class_3532.method_16436((double)this.yRotAnimation.getValue(), (double)this.prevYRot, (double)this.yRot);
    }

    public double getMaxRotationXDegrees() {
        return 40.0;
    }

    public double getMaxRotationYDegrees() {
        return 30.0;
    }

    public double getRotationXStepDegrees() {
        return 5.0;
    }

    public double getRotationYStepDegrees() {
        return 5.0;
    }

    public void toggle() {
        class_5498 newCameraType = Minecrft.options().method_31044() == class_5498.field_26664 ? class_5498.field_26666 : class_5498.field_26664;
        Minecrft.options().method_31043(newCameraType);
    }

    public void updateSelfieMode() {
        boolean inSelfieMode;
        boolean bl = inSelfieMode = Minecrft.options().method_31044() == class_5498.field_26666;
        if (this.camera.inSelfieMode() != inSelfieMode) {
            CameraSettings.SELFIE_MODE.setAndSync(this.camera, inSelfieMode);
            CameraSettings.SELFIE_ROTATION_X.setAndSync(this.camera, 0.0);
            CameraSettings.SELFIE_ROTATION_Y.setAndSync(this.camera, 0.0);
            this.xRot = 0.0;
            this.yRot = 0.0;
            this.rawXRot = 0.0;
            this.rawYRot = 0.0;
        }
    }

    public boolean mouseMove(double xRotDelta, double yRotDelta) {
        if (!this.viewfinder.controlsActive() && this.camera.inSelfieMode() && Minecrft.options().field_1867.field_1653) {
            this.rotateCamera(xRotDelta, yRotDelta, false);
            return true;
        }
        return false;
    }

    public void rotateCamera(double xRotDelta, double yRotDelta, boolean precise) {
        double maxX = this.getMaxRotationXDegrees();
        double maxY = this.getMaxRotationYDegrees();
        this.rawXRot = class_3532.method_15350((double)(this.rawXRot + xRotDelta * 0.15), (double)(-maxX), (double)maxX);
        this.rawYRot = class_3532.method_15350((double)(this.rawYRot + yRotDelta * 0.15), (double)(-maxY), (double)maxY);
        double stepX = this.getRotationXStepDegrees() * (precise ? 0.25 : 1.0);
        double stepY = this.getRotationYStepDegrees() * (precise ? 0.25 : 1.0);
        double xr = (double)((int)this.rawXRot) - (double)((int)this.rawXRot) % stepX;
        double yr = (double)((int)this.rawYRot) - (double)((int)this.rawYRot) % stepY;
        if (xr != this.prevXRot) {
            this.prevXRot = this.getCameraXRot();
            this.xRot = xr;
            this.xRotAnimation.resetProgress();
            CameraSettings.SELFIE_ROTATION_X.setAndSync(this.camera, this.xRot);
        }
        if (yr != this.prevYRot) {
            this.prevYRot = this.getCameraYRot();
            this.yRot = yr;
            this.yRotAnimation.resetProgress();
            CameraSettings.SELFIE_ROTATION_Y.setAndSync(this.camera, this.yRot);
        }
    }
}

